# -*- encoding: utf-8 -*-
'''
@File    :   sound.py
@Time    :   2021/11/09 23:09:41
@Author  :   Muyao ZHONG 
@Version :   1.0
@Contact :   zmy125616515@hotmail.com
@License :   (C)Copyright 2019-2020
@Title   :   All sounds
'''

import sys
import os
sys.path.append(os.path.abspath('./'))

from pygame import mixer
from GamePackage.GameBase.base import Base
import time


class Mixer(Base):
    def __init__(self):
        super().__init__()
        mixer.init()
        self.sound=mixer.music
        
    def load(self,filename):
        self.sound.load(filename)
        
    def play(self,fade_ms=0):
        self.sound.play(fade_ms=fade_ms)
        
        
if __name__ == '__main__':
    m=Mixer()
    m.load("./GamePackage/GameSound/Castle3.ogg")
    m2=Mixer()
    m2.load("./GamePackage/GameSound/Castle1.ogg")
    m.play(fade_ms=4000)
    time.sleep(2)
    m2.play(fade_ms=2000)
    time.sleep(6)
    m.sound.fadeout(5000)
    time.sleep(5)
    m2.sound.fadeout(4000)
    time.sleep(6)