# -*- encoding: utf-8 -*-
'''
@File    :   manager.py
@Time    :   2021/04/21 00:11:46
@Author  :   Muyao ZHONG 
@Version :   1.0
@Contact :   zmy125616515@hotmail.com
@License :   (C)Copyright 2019-2020
@Title   :   An manager for achievement.
'''

import sys
import os
sys.path.append(os.path.abspath('./'))
# sys.path.append('/Users/zhongmuyao/Library/Mobile Documents/com~apple~CloudDocs/Project.nosync/python3/pygengin')
from GamePackage.GameConfig.manager import *
from GamePackage.GameBase.base import Base
from GamePackage.GameData.manager import DataManager
import time,json

def get_achievement_data():
    c=ConfigeManager()
    return c.get_option('achievement_data')

class AchieveManager(Base):
    def __init__(self,acv_json_path,record_json_path):
        super().__init__()
        self.dm=DataManager()
        self.acv_json_path=acv_json_path
        self.record_json_path=record_json_path
        self.data=self.dm.load(acv_json_path)
        
        self.records=self.dm.load(record_json_path)
        self.achievements=self.data['achievements']
        self.groups=self.data['groups']
        # self.records=self.data['records']
        # self.target=self.data['target']
        # self.progresses=self.data['progress']
        # self.reward=self.data['reward']
        # self.group_reward=self.data['group_reward']
        self.achievements_show=[]
        self.get_show_acv()
        
    def get_show_acv(self):
        for i in self.achievements:
            if i['show']==1:
                self.achievements_show.append(i)
        return
    
    def progress(self,index,progress):
        """用于记录成就进度，如果完成了成就则获得对应的奖励，解锁对应额成就，如果完成了成就组中的所有成就，则颁发组奖励，并解锁后续的成就组。

        Args:
            index (int): 成就的索引
            progress (int): 成就的进度值
        """
        if index<0 or index>len(self.achievements):
            return
        # 成就如果未解锁则直接返回
        a=self.achievements[index]
        if a['show']==0: 
            return
        
        a["progress"]+=progress
        
        # 如果成就第一次达成，则触发相应的操作
        if a["target"]<=a["progress"] and a["timestamp"]=="":
            a["timestamp"]=time.time()
            # TODO： 实际发放奖励
            print("Congraduations, you have got the reward of this achievement:{}".format(a["reward"]))
            l=len(a["next"])
            if l!=0:
                for i in a["next"]:
                    self.achievements[i]["show"]=1
                    self.achievements_show.append(self.achievements[i])
                    print("The achievement {} is unlocked! The reward is {} Go ahead for it!".format(self.achievements[i]["name"],self.achievements[i]["reward"]))
            g=self.groups[a["group"]]
            if self.check_group_complete(g):
                # TODO: 实际发放奖励
                print("You have got the group reward:{}".format(g["reward"]))
                g["timestamp"]=time.time()
                next=g["next"]
                if len(next)!=0:
                    for i in next:
                        self.groups[i]["show"]=1
                        print("The achievement group {} is unlocked! The group reward is {}. Go for it !".format(self.groups[i]["name"],self.groups[i]["reward"]))
                        
    def record(self,index,progress):
        r=self.records[index]
        if "" in r["timestamp"]:
            t=r["timestamp"].index("")
            r['progress']+=progress
            if r['progress']>=r["target"][t]:
                r["timestamp"][t]=time.time() 
                # TODO： 实际发放奖励
                print("You have got the reward {}.".format(r["reward"][t]))
        else:
            r['progress']+=progress
        
        
            
    def save(self,tp="achievements"):
        if tp in ["r","record","records"]:
            self.dm.save(self.record_json_path,self.records)
            print("Records Data Updated!")
        elif tp in ["a","achv","achievement","achievements"]:
            tmp={
                    "achievements":self.achievements,
                    "groups":self.groups,
                }
            self.dm.save(self.acv_json_path,tmp)
            print("Achievement Data Updated!")
        
    def check_group_complete(self,g):
        ga=g["acvs"]
        for a in ga:
            if self.check_acv_complete(a)==False:
                return False
        return True
        
    def check_acv_complete(self,index):
        return self.achievements[index]["timestamp"]!=""
        
                
    def get_group_name_by_index(self,index):
        return self.groups[index]["name"]
    
    def __str__(self):
        res="{:<6}{:<20}{:<20}{:<30}{:<15}{:<10}\n".format("Index","GroupName","AchieveName","Describe","Progress","GetTime")
        for a in self.achievements_show:
            pro="{:d}/{:d}".format(a["progress"],a["target"]) if a["target"]<a["progress"] else "Done"
            res+="{:<6}{:<20}{:<20}{:<30}{:<15}{:<10}\n".format(a['index'],self.get_group_name_by_index(a["group"]),a['name'],a['describe'],pro,a['timestamp'])
        return res
            
            
        
if __name__ == '__main__':
    a=AchieveManager("achv.json","record.json")
    a.progress(2,9)
    a.record(0,90000)
    a.save(tp="achievement")
    print(a)