# DeepChem Step-by-Step Tutorial

In this tutorial series, you'll learn how to use DeepChem to solve interesting
and challenging problems in the life sciences. This tutorial series is
continually updated with new DeepChem features and models as implemented and is
designed to be accessible to beginners.

## Why do the DeepChem Tutorial?

**1) Career Advancement:** Applying AI in the life sciences is a booming
industry at present. There are a host of newly funded startups and initiatives
at large pharmaceutical and biotech companies centered around AI. Learning and
mastering DeepChem will bring you to the forefront of this field and will
prepare you to enter a career in this field.

**2) Humanitarian Considerations:** Disease is the oldest cause of human
suffering. From the dawn of human civilization, humans have suffered from pathogens,
cancers, and neurological conditions. One of the greatest achievements of
the last few centuries has been the development of effective treatments for
many diseases. By mastering the skills in this tutorial, you will be able to
stand on the shoulders of the giants of the past to help develop new
medicine.

**3) Lowering the Cost of Medicine:** The art of developing new medicine is
currently an elite skill that can only be practiced by a small core of expert
practitioners. By enabling the growth of open source tools for drug discovery,
you can help democratize these skills and open up drug discovery to more
competition. Increased competition can help drive down the cost of medicine.

## You Will Learn
* [Part 1: The Basic Tools of the Deep Life Sciences](The_Basic_Tools_of_the_Deep_Life_Sciences.ipynb)
* [Part 2: Learning MNIST Digit Classifiers](mnist.ipynb)
* [Part 3: Introduction to Graph Convolutions](graph_convolutional_networks_for_tox21.ipynb)
* [Part 4: Uncertainty Modeling in Deep Learning](Uncertainty.ipynb)
* [Part 5: Model Interpretability](Explaining_Tox21.ipynb)
