# DeepChem Step-by-Step Tutorial

In this tutorial series, you'll learn how to use DeepChem to solve interesting
and challenging problems in the life sciences. This tutorial series is
continually updated with new DeepChem features and models as implemented and is
designed to be accessible to beginners.

## Why do the DeepChem Tutorial?

**1) Career Advancement:** Applying AI in the life sciences is a booming
industry at present. There are a host of newly funded startups and initiatives
at large pharmaceutical and biotech companies centered around AI. Learning and
mastering DeepChem will bring you to the forefront of this field and will
prepare you to enter a career in this field.

**2) Humanitarian Considerations:** Disease is the oldest cause of human
suffering. From the dawn of human civilization, humans have suffered from pathogens,
cancers, and neurological conditions. One of the greatest achievements of
the last few centuries has been the development of effective treatments for
many diseases. By mastering the skills in this tutorial, you will be able to
stand on the shoulders of the giants of the past to help develop new
medicine.

**3) Lowering the Cost of Medicine:** The art of developing new medicine is
currently an elite skill that can only be practiced by a small core of expert
practitioners. By enabling the growth of open source tools for drug discovery,
you can help democratize these skills and open up drug discovery to more
competition. Increased competition can help drive down the cost of medicine.

## You Will Learn
* [Part 1: The Basic Tools of the Deep Life Sciences](01_The_Basic_Tools_of_the_Deep_Life_Sciences.ipynb)
* [Part 2: Learning MNIST Digit Classifiers](02_Learning_MNIST_Digit_Classifiers.ipynb)
* [Part 3: Modeling Solubility](03_Modeling_Solubility.ipynb)
* [Part 4: Introduction to Graph Convolutions](04_Introduction_to_Graph_Convolutions.ipynb)
* [Part 5: Putting Multitask Learning to Work](05_Putting_Multitask_Learning_to_Work.ipynb)
* [Part 6: Going Deeper on Molecular Featurizations](06_Going_Deeper_on_Molecular_Featurizations.ipynb)
* [Part 7: Uncertainty in Deep Learning](07_Uncertainty_In_Deep_Learning.ipynb)
* [Part 8: Introduction to Model Interpretability](08_Introduction_to_Model_Interpretability.ipynb)
* [Part 9: Creating a high fidelity model from experimental data](09_Creating_a_high_fidelity_model_from_experimental_data.ipynb)
* [Part 10: Exploring Quantum Chemistry with GDB1k](10_Exploring_Quantum_Chemistry_with_GDB1k.ipynb)
* [Part 11: Learning Unsupervised Embeddings for Molecules](11_Learning_Unsupervised_Embeddings_for_Molecules.ipynb)
* [Part 12: Predicting Ki of Ligands to a Protein](12_Predicting_Ki_of_Ligands_to_a_Protein.ipynb)
* [Part 13: Modeling Protein Ligand Interactions](13_Modeling_Protein_Ligand_Interactions.ipynb)
* [Part 14: Modeling Protein Ligand Interactions With Atomic Convolutions](14_Modeling_Protein_Ligand_Interactions_With_Atomic_Convolutions.ipynb)
* [Part 15: Synthetic Feasibility Scoring](15_Synthetic_Feasibility_Scoring.ipynb)
* [Part 16: Conditional Generative Adversarial Networks](16_Conditional_Generative_Adversarial_Networks.ipynb)
* [Part 17: Training a Generative Adversarial Network on MNIST](17_Training_a_Generative_Adversarial_Network_on_MNIST.ipynb)
* [Part 18: Using Reinforcement Learning to Play Pong](18_Using_Reinforcement_Learning_to_Play_Pong.ipynb)
* [Part 19: Large Scale Chemical Screens](19_Large_Scale_Chemical_Screens.ipynb)
* [Part 20: ConvertingDeepChem Models to TensorFlow Estimators](20_Converting_DeepChem_Models_to_TensorFlow_Estimators.ipynb)
* [Part 21: Introduction to Bioinformatics](21_Introduction_to_Bioinformatics.ipynb)
* [Part 22: Using HuggingFace + Transfer Learning for Toxicity Predictions](22_Transfer_Learning_With_HuggingFace_tox21.ipynb)


