
package GameUI;

import java.awt.Font;
import javax.swing.JPanel;
import javax.swing.JProgressBar;

public class TopBar extends JPanel {
    private JProgressBar scoreBar = new JProgressBar();

    public TopBar(/* int x, int y, */ int width, int height) {
        this.add(scoreBar);
        // this.scoreBar.setLocation(x, y);
        this.scoreBar.setSize(width, height);
        // TODO set to proper size & location
        this.scoreBar.setFont(new Font("Calibri", Font.PLAIN, 20));
        this.setScoreBar(2, 2);
    }

    public void setScoreBar(int blackScore, int whiteScore) {
        double vs = ((float) (blackScore) / ((float) (blackScore + whiteScore)));
        int vs100 = (int) (vs * 100);
        this.scoreBar.setValue(vs100);
        this.scoreBar.setIndeterminate(false);
        this.scoreBar.setStringPainted(true);
        this.scoreBar.setString(String.format("BLACK: %d  <<>>  WHITE: %d", blackScore, whiteScore));
    }

}
