
package GameUI;

import java.awt.*;
import javax.swing.*;

import Model.ChessPiece;

public class StatusUI extends JPanel {
	private String blackPlayer;
	private String whitePlayer;
	private ChessPiece currentPlayer;
	private int blackScore;
	private int whiteScore;

	public StatusUI(String blackPlayer, String whitePlayer) {
		this.blackPlayer = blackPlayer;
		this.whitePlayer = whitePlayer;
		currentPlayer = ChessPiece.BLACK;
		initComponents();
	}

	public void setScore(int blackScore, int whiteScore) {
		this.blackScore = blackScore;
		this.whiteScore = whiteScore;
		refeshAll();
	}

	public void setCurrentPlayer(ChessPiece currentPlayer) {
		this.currentPlayer = currentPlayer;
		refeshAll();
	}

	private void refeshAll() {
		blackScoreLabel.setText("  Black: " + String.valueOf(this.blackScore));
		whiteScoreLabel.setText("  White: " + String.valueOf(this.whiteScore));
		Player.setText("  " + currentPlayer);
	}

	JLabel blackScoreLabel = new JLabel();
	JLabel whiteScoreLabel = new JLabel();
	JLabel Turn = new JLabel();
	JLabel Player = new JLabel();

	private void initComponents() {
		// JFormDesigner - Component initialization - DO NOT MODIFY
		// //GEN-BEGIN:initComponents
		JPanel scorePanel = new JPanel();
		JLabel ScoreTitle = new JLabel();
		JLabel vacant = new JLabel();
		Font standard = new Font("\u6977\u4f53", Font.BOLD, 18);

		// ======== scorePanel ========
		{
			scorePanel.setLayout(new BoxLayout(scorePanel, BoxLayout.Y_AXIS));

			vacant.setText(" ");

			// ---- Turn ----
			Turn.setText(" Turn");
			Turn.setHorizontalAlignment(SwingConstants.LEFT);
			Turn.setFont(standard);
			scorePanel.add(Turn);

			// ---- Player ----
			Player.setFont(standard);
			scorePanel.add(Player);
			scorePanel.add(vacant);

			// ---- ScoreTitle ----
			ScoreTitle.setText(" Score");
			ScoreTitle.setFont(standard);
			scorePanel.add(ScoreTitle);

			// scorePanel.add(vacant);

			// ---- blackScoreLabel ----
			blackScoreLabel.setText("  Black: " + String.valueOf(this.blackScore));
			blackScoreLabel.setVerticalTextPosition(SwingConstants.TOP);
			blackScoreLabel.setVerifyInputWhenFocusTarget(false);
			blackScoreLabel.setFont(standard);
			scorePanel.add(blackScoreLabel);

			// ---- whiteScoreLabel ----
			whiteScoreLabel.setText("  White: " + String.valueOf(this.whiteScore));
			whiteScoreLabel.setFont(standard);
			scorePanel.add(whiteScoreLabel);
		}
		// JFormDesigner - End of component initialization //GEN-END:initComponents
		this.setLayout(new BoxLayout(this, BoxLayout.Y_AXIS));
		this.add(Turn);
		this.add(scorePanel);
	}
}
