package GameUI;

import javax.swing.JFileChooser;

public class FileChooser extends JFileChooser {
    private int clickFlag;

    FileChooser(boolean sign) {
        super("D:/");
        if (sign) {
            this.setFileSelectionMode(FILES_ONLY);
            clickFlag = this.showOpenDialog(null);
        } else {
            this.setFileSelectionMode(DIRECTORIES_ONLY);
            clickFlag = this.showSaveDialog(null);
        }
    }

    private boolean clickYes() {
        return clickFlag == JFileChooser.APPROVE_OPTION;
    }

    public String Path() {
        if (clickYes())
            return this.getSelectedFile().getPath();
        return null;
    }
}
