package GameUI;

import java.awt.*;
import java.awt.event.*;
import java.text.DecimalFormat;

import javax.swing.*;
/*
 * Created by JFormDesigner on Tue Nov 30 22:41:46 CST 2021
 */

import Core.GameCore;
import Model.CheatStatus;

/**
 * @author uint44t
 */
public class ChessGameUI extends JPanel {

	public ChessGameUI() {
		initComponents();
	}

	private int rows = 8;
	private int cols = 8;

	public static GameCore thisGameCore;
	public static StatusUI thisStatus;
	public static CheatStatus thisCheatModeStatus = CheatStatus.Off;// cheat模式的选择状态
	private PlayerName thisPlayerName;

	public CheatStatus getCheatStatus() {
		return thisCheatModeStatus;
	}

	private void importButtonActionPerformed() {// import按钮触发事件
		String tem = new FileChooser(true).Path();
		if (tem != null)
			thisGameCore.setImportpath(tem);
	}

	private void exportButtonActionPerformed() {// export按钮触发事件
		String tem = new FileChooser(false).Path();
		if (tem != null)
			thisGameCore.setImportpath(tem);
	}

	private void restartButtonActionPerformed() {// restart按钮触发事件
		// TODO add your code here
	}

	private void undoButtonActionPerformed() {// undo按钮触发事件
		// TODO add your code here
	}

	private void cheatOnOffButtonActionPerformed() {// cheat单选按钮被按下的触发事件
		if (cheatOnOff.isSelected()) {
			cheat.setVisible(true);
			thisCheatModeStatus = CheatStatus.Black;
		} else {
			cheat.setVisible(false);
			thisCheatModeStatus = CheatStatus.Off;
			System.out.println("cheatoff");
		}
	}

	private void cheatListener(ItemEvent e) {// 上面出发后弹出的选项卡的触发事件
		String select = e.getItem().toString();
		if (cheatOnOff.isSelected()) {
			switch (select) {
				case "Black" -> thisCheatModeStatus = CheatStatus.Black;
				case "White" -> thisCheatModeStatus = CheatStatus.White;
			}
		} else {
			thisCheatModeStatus = CheatStatus.Off;
		}
		System.out.println(select);
	}

	// JFrame background = new JFrame();
	JPanel bottomButtons = new JPanel();
	JButton importButton = new JButton();
	JButton exportButton = new JButton();
	JButton restartButton = new JButton();
	JButton undoButton = new JButton();
	JComboBox cheat = new JComboBox();
	JRadioButton cheatOnOff = new JRadioButton();
	JPanel center;

	private void initComponents() {
		// JFormDesigner - Component initialization - DO NOT MODIFY
		// //GEN-BEGIN:initComponents
		thisStatus = new StatusUI("blackPlayer", "whitePlayer");
		thisPlayerName = new PlayerName("blackName", "whiteName");
		thisGameCore = new GameCore(rows, cols);

		// ======== background ========
		{
			this.setVisible(true);
			this.setLayout(new BorderLayout(10, 5));
			this.setPreferredSize(new Dimension(700, 500));
			this.addComponentListener(new ComponentAdapter() {
				@Override
				public void componentResized(ComponentEvent e) {
					thisGameCore.zoom(getWidth(), getHeight());
					thisGameCore.getGamePanel().updateUI();
					// System.out.println(background.getWidth() + "\t" + background.getHeight());
				}
			});
			center = new JPanel();
			center.add(thisGameCore.getGamePanel());
			// background.add(new JPanel().add(thisGameCore.getGamePanel()),
			// BorderLayout.CENTER);
			this.add(center, BorderLayout.CENTER);
			this.add(thisStatus, BorderLayout.WEST);
			this.add(thisPlayerName, BorderLayout.EAST);

			// ======== bottomButtons ========
			{
				bottomButtons.setLayout(new FlowLayout(FlowLayout.CENTER, 5, 5));
				((FlowLayout) bottomButtons.getLayout()).setAlignOnBaseline(true);

				// ---- importButton ----
				importButton.setText("Import");
				importButton.addActionListener(e -> importButtonActionPerformed());
				bottomButtons.add(importButton);

				// ---- exportButton ----
				exportButton.setText("Export");
				exportButton.addActionListener(e -> exportButtonActionPerformed());
				bottomButtons.add(exportButton);

				// ---- restartButton ----
				restartButton.setText("Restart");
				restartButton.addActionListener(e -> restartButtonActionPerformed());
				bottomButtons.add(restartButton);

				// ---- undoButton ----
				undoButton.setText("Undo");
				undoButton.addActionListener(e -> undoButtonActionPerformed());
				bottomButtons.add(undoButton);

				// ---- cheatOnOff ----
				cheatOnOff.setText("Cheat");
				cheatOnOff.addActionListener(e -> cheatOnOffButtonActionPerformed());
				bottomButtons.add(cheatOnOff);

				// cheat
				cheat.addItem("Black");
				cheat.addItem("White");
				cheat.setVisible(false);
				cheat.addItemListener(e -> cheatListener(e));
				bottomButtons.add(cheat);

			}
			this.add(bottomButtons, BorderLayout.SOUTH);
		}

		// JFormDesigner - End of component initialization //GEN-END:initComponents
	}
	// JFormDesigner - Variables declaration - DO NOT MODIFY //GEN-BEGIN:variables
	// JFormDesigner - End of variables declaration //GEN-END:variables
}
