package Core;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

import Components.ChessBoardPanel;
import GameUI.ChessGameUI;
import Model.ChessPiece;

public class GameCore {
    private ChessBoardPanel gamePanel;// 棋盘
    private int blackScore;// 字面意思
    private int whiteScore;
    private ChessPiece currentPlayer;// 当前该谁下棋
    private String importPath;
    private String exportPath;
    private int panelWidth;
    private int panelHeight;

    public GameCore(int rows, int cols) {
        this.gamePanel = new ChessBoardPanel(rows, cols);
        this.currentPlayer = ChessPiece.BLACK;
        intializeChess();
        blackScore = 2;
        whiteScore = 2;
        ChessGameUI.thisStatus.setScore(blackScore, whiteScore);
    }

    private void intializeChess() {// 初始化放棋
        gamePanel.setChess(3, 3, ChessPiece.BLACK);
        gamePanel.setChess(4, 4, ChessPiece.BLACK);
        gamePanel.setChess(3, 4, ChessPiece.WHITE);
        gamePanel.setChess(4, 3, ChessPiece.WHITE);
    }

    public void swapPlayer() {// 交换玩家
        countScore();
        currentPlayer = (currentPlayer == ChessPiece.BLACK) ? ChessPiece.WHITE : ChessPiece.BLACK;
        ChessGameUI.thisStatus.setCurrentPlayer(currentPlayer);
        ChessGameUI.thisStatus.setScore(blackScore, whiteScore);
        if (this.currentPlayer == ChessPiece.BLACK) {
            this.currentPlayer = ChessPiece.WHITE;
        } else {
            this.currentPlayer = ChessPiece.BLACK;
        }
        // todo:complete status panel
        // statusPanel.setPlayerText(currentPlayer.name());
        // statusPanel.setScoreText(blackScore, whiteScore);
    }

    public void zoom(int outerWidth, int outHeight) {// 缩放
        panelWidth = outerWidth;
        panelHeight = outHeight;
        gamePanel.autoZoom(panelWidth, panelHeight);
        // todo complete zoom
    }

    public void countScore() {// 计分
        // todo: modify the countScore method
    }

    public void readFileData(String fileName) {// 读存档
        // todo: read date from file
        List<String> fileData = new ArrayList<>();
        try {
            FileReader fileReader = new FileReader(fileName);
            BufferedReader bufferedReader = new BufferedReader(fileReader);
            String line;
            while ((line = bufferedReader.readLine()) != null) {
                fileData.add(line);
            }
            fileData.forEach(System.out::println);
        } catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void writeDataToFile(String fileName) {// 写存档
        // todo: write data into file
    }

    public boolean canClick(int row, int col) {// 可以被点击
        // todo
        return gamePanel.canClickGrid(row, col, currentPlayer);
    }

    public void undo() {// 撤销
        // todo
    }

    private ChessPiece checkWinner() {// 检测胜者
        // todo（用ChessPiece.EMPTY表示平局）
        return null;
    }

    private boolean canMove() {// 当前玩家有处可下
        // todo
        return true;
    }

    public void setImportpath(String importPath) {
        this.importPath = importPath;
        System.out.println(this.importPath);
        readFileData(importPath);
    }

    public void setExportPath(String exportPath) {
        this.exportPath = exportPath;
        System.out.println(this.exportPath);
        writeDataToFile(exportPath);
    }

    public ChessPiece getCurrentPlayer() {
        return currentPlayer;
    }

    public ChessBoardPanel getGamePanel() {// 应该没啥用
        return gamePanel;
    }

    public int getRows() {
        return 8;
    }

    public int getCols() {
        return 8;
    }
}
