package Core;

public class DigitBoard {
    int[][] inBoard = new int[8][8];
    int[][] outBoard = new int[8][8];
    int[][] operate = new int[1][2];
    int color = 0;

    public DigitBoard(int row, int col, int color, int[][] digitBoard) {
        this.inBoard = digitBoard;
        this.color = color;
        this.operate[0][0] = row;
        this.operate[0][1] = col;
    }


    public void DoLogic() {
        for (int i = 0, flag = 0; i != 1; this.color *= -1, flag = 0, ++i) {
            boolean[][][] direction = CheckAvailable(this.inBoard, this.operate[i], this.color);
            for (int j = 0; j != 8; ++j) {
                if (direction[this.operate[i][0]][this.operate[i][1]][j]) {
                    ++flag;
                    this.inBoard = OperateMat(this.inBoard, this.operate[i], direction, this.color);
                }
            }
            if (flag == 0)
                break;
        }
        for (int i = 0; i < 8; i++) {
            System.arraycopy(this.inBoard[i], 0, this.outBoard[i], 0, 8);
        }
    }

    public int getAns(int y, int x) { return this.outBoard[y][x]; }

    public static boolean CheckEmptyPoint(int[][] mat, int[] pos, int color) {
        return mat[pos[0]][pos[1]] == 0;
    }

    public static boolean CheckRivalColorLine(int[][] mat, int row, int col, int pointColor, int rowFlag, int colFlag) {
        for (; row + rowFlag > -1 && row + rowFlag < 8 && col + colFlag > -1
                && col + colFlag < 8; rowFlag = FlagChange(rowFlag), colFlag = FlagChange(colFlag)) {
            if (mat[row + rowFlag][col + colFlag] == 0)
                return false;
            if (mat[row + rowFlag][col + colFlag] == pointColor)
                return false;
            if (mat[row + rowFlag][col + colFlag] == -pointColor)
                return true;
        }
        return false;
    }

    public static boolean CheckSelfColorLine(int[][] mat, int row, int col, int pointColor, int rowFlag, int colFlag) {
        for (int count = 0; row + rowFlag > -1 && row + rowFlag < 8 && col + colFlag > -1
                && col + colFlag < 8; rowFlag = FlagChange(rowFlag), colFlag = FlagChange(colFlag), ++count) {
            if (mat[row + rowFlag][col + colFlag] == 0)
                return false;
            if (mat[row + rowFlag][col + colFlag] == pointColor) {
                return count != 0;
            }
        }
        return false;
    }

    public static int[][] ChangeRivalColor(int[][] mat, int[] pos, int rowFlag, int colFlag, int selfcolor) {
        int[][] result = mat;
        for (; pos[0] + rowFlag > -1 && pos[0] + rowFlag < 8 && pos[1] + colFlag > -1
                && pos[1] + colFlag < 8; rowFlag = FlagChange(rowFlag), colFlag = FlagChange(colFlag)) {
            if (mat[pos[0] + rowFlag][pos[1] + colFlag] == selfcolor)
                break;
            if (mat[pos[0] + rowFlag][pos[1] + colFlag] == -selfcolor) {
                result[pos[0] + rowFlag][pos[1] + colFlag] = selfcolor;
            }
        }
        return result;
    }

    public static int FlagChange(int flag) {
        if (flag == 0)
            ;
        else if (flag < 0)
            --flag;
        else
            ++flag;
        return flag;
    }

    public static boolean[][][] CheckAvailable(int[][] mat, int[] pos, int color) {
        boolean[][][] direction = new boolean[8][8][8];
        if (CheckEmptyPoint(mat, pos, color)) {
            if (CheckRivalColorLine(mat, pos[0], pos[1], color, 1, 0)
                    && CheckSelfColorLine(mat, pos[0], pos[1], color, 1, 0))
                direction[pos[0]][pos[1]][4] = true;
            if (CheckRivalColorLine(mat, pos[0], pos[1], color, -1, 0)
                    && CheckSelfColorLine(mat, pos[0], pos[1], color, -1, 0))
                direction[pos[0]][pos[1]][0] = true;
            if (CheckRivalColorLine(mat, pos[0], pos[1], color, 0, -1)
                    && CheckSelfColorLine(mat, pos[0], pos[1], color, 0, -1))
                direction[pos[0]][pos[1]][6] = true;
            if (CheckRivalColorLine(mat, pos[0], pos[1], color, 0, 1)
                    && CheckSelfColorLine(mat, pos[0], pos[1], color, 0, 1))
                direction[pos[0]][pos[1]][2] = true;
            if (CheckRivalColorLine(mat, pos[0], pos[1], color, -1, -1)
                    && CheckSelfColorLine(mat, pos[0], pos[1], color, -1, -1))
                direction[pos[0]][pos[1]][7] = true;
            if (CheckRivalColorLine(mat, pos[0], pos[1], color, 1, 1)
                    && CheckSelfColorLine(mat, pos[0], pos[1], color, 1, 1))
                direction[pos[0]][pos[1]][3] = true;
            if (CheckRivalColorLine(mat, pos[0], pos[1], color, -1, 1)
                    && CheckSelfColorLine(mat, pos[0], pos[1], color, -1, 1))
                direction[pos[0]][pos[1]][1] = true;
            if (CheckRivalColorLine(mat, pos[0], pos[1], color, 1, -1)
                    && CheckSelfColorLine(mat, pos[0], pos[1], color, 1, -1))
                direction[pos[0]][pos[1]][5] = true;
        }
        return direction;
    }

    public static int[][] OperateMat(int[][] mat, int[] position, boolean[][][] direction, int color) {
        int[][] result = new int[8][8];
        for (int k = 0; k != 8; ++k) {
            if (direction[position[0]][position[1]][k]) {
                int rowFlag, colFlag;
                switch (k) {
                    case 0:
                        rowFlag = -1;
                        colFlag = 0;
                        result = ChangeRivalColor(mat, position, rowFlag, colFlag, color);
                        break;
                    case 1:
                        rowFlag = -1;
                        colFlag = 1;
                        result = ChangeRivalColor(mat, position, rowFlag, colFlag, color);
                        break;
                    case 2:
                        rowFlag = 0;
                        colFlag = 1;
                        result = ChangeRivalColor(mat, position, rowFlag, colFlag, color);
                        break;
                    case 3:
                        rowFlag = 1;
                        colFlag = 1;
                        result = ChangeRivalColor(mat, position, rowFlag, colFlag, color);
                        break;
                    case 4:
                        rowFlag = 1;
                        colFlag = 0;
                        result = ChangeRivalColor(mat, position, rowFlag, colFlag, color);
                        break;
                    case 5:
                        rowFlag = 1;
                        colFlag = -1;
                        result = ChangeRivalColor(mat, position, rowFlag, colFlag, color);
                        break;
                    case 6:
                        rowFlag = 0;
                        colFlag = -1;
                        result = ChangeRivalColor(mat, position, rowFlag, colFlag, color);
                        break;
                    case 7:
                        rowFlag = -1;
                        colFlag = -1;
                        result = ChangeRivalColor(mat, position, rowFlag, colFlag, color);
                        break;
                }
            }
        }
        result[position[0]][position[1]] = color;
        return result;
    }
}
