package Components;

import javax.swing.ImageIcon;
import GameUI.ChessGameUI;

import java.awt.*;
import Model.ChessPiece;

public class ChessPanel extends BasicComponent {
    private int row;
    private int col;
    private static int size = 8;
    private ChessPiece playersChess;
    ImageIcon emptyImg = new ImageIcon("Model/empty.png");
    ImageIcon whiteImg = new ImageIcon("Model/white1.png");
    ImageIcon blcakImg = new ImageIcon("Model/black1.png");
    ImageIcon image;

    ChessPanel(int row, int col) {
        setVisible(true);
        this.row = row;
        this.col = col;
        // setPreferredSize(new Dimension(40, 40));
        image = emptyImg;
        playersChess = ChessPiece.EMPTY;

    }

    public static void setSize(int size) {
        ChessPanel.size = size;
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension space = getParent().getParent().getSize();
        int length = 8 * (Math.min(space.width / 8, space.height / 8));
        // System.out.println(space.width + "\t" + space.height + "\t" + length);
        return new Dimension(length, length);
    }

    @Override
    public void onMouseClicked() {// todo 鼠标点击时的动作
        System.out.printf("%s clicked (%d, %d)\n",
                ChessGameUI.thisGameCore.getCurrentPlayer(), row, col);
        // todo: complete mouse click method
        if (ChessGameUI.thisGameCore.canClick(row, col)) {// todo

            this.playersChess = ChessGameUI.thisGameCore.getCurrentPlayer();
            ChessGameUI.thisGameCore.swapPlayer();
            paintChess(playersChess);

        }
    }

    @Override
    protected void paintComponent(Graphics g) {// 画棋子
        super.paintComponent(g);

        int width = this.getWidth();
        int height = this.getHeight();
        int drawWidth = Math.min(width, height);
        int drawHeight = drawWidth;

        Image imageTrans = image.getImage(); // transform it
        int size = drawWidth;
        Image newimg = imageTrans.getScaledInstance(size, size, java.awt.Image.SCALE_SMOOTH); // scale it the smooth way
        ImageIcon imgZoomed = new ImageIcon(newimg); // transform it back

        imgZoomed.paintIcon(this, g, 0, 0);
        // System.out.println(width);
    }

    private void paintChess(ChessPiece playersChess) {// 画棋子
        switch (playersChess) {
            case BLACK -> image = blcakImg;
            case WHITE -> image = whiteImg;
            case EMPTY -> image = emptyImg;
            default -> throw new IllegalArgumentException("Unexpected value: " + playersChess);
        }
        repaint();
    }

    public void configSize(int grindPanelSize) {// 初始化长宽
    }

    public ChessPiece getChessPiece() {// 获取当前位置的棋子
        return playersChess;
    }

    public void setChessPiece(ChessPiece player) {// 放棋
        this.playersChess = player;
        paintChess(this.playersChess);
    }

    /* 获取当前棋子的行列(好像没啥用) */
    public int getRow() {
        return row;
    }

    public int getCol() {
        return col;
    }
}
