package Components;

import java.awt.*;

import GameUI.ChessGameUI;
import Model.ChessPiece;

public class ChessGridComponent extends BasicComponent {
    public static int chessSize;
    public static int gridSize;
    public static Color gridColor = new Color(255, 150, 50);

    private ChessPiece chessPiece;
    private ChessPanel chess;
    private int row;
    private int col;

    public ChessGridComponent(int row, int col) {
        // this.setSize(gridSize, gridSize);

        this.row = row;
        this.col = col;
    }

    @Override
    public void onMouseClicked() {
        // System.out.printf("%s clicked (%d, %d)\n", GameCore.getCurrentPlayer(), row,
        // col);
        // todo: complete mouse click method
        if (ChessGameUI.thisGameCore.canClick(row, col)) {
            if (this.chessPiece == ChessPiece.EMPTY) {
                this.chessPiece = ChessGameUI.thisGameCore.getCurrentPlayer();
                ChessGameUI.thisGameCore.swapPlayer();
            }
            repaint();
        }
    }

    public ChessPiece getChessPiece() {
        return chessPiece;
    }

    public void setChessPiece(ChessPiece playersChessPiece) {
        this.chessPiece = playersChessPiece;
    }

    public int getRow() {
        return row;
    }

    public int getCol() {
        return col;
    }

    public void drawPiece(Graphics g) {
        // g.setColor(gridColor);
        // g.fillRect(1, 1, this.getWidth() - 2, this.getHeight() - 2);// fill the rect
        // with chessboard color
        // if (this.chessPiece != null) {
        // g.setColor(chessPiece.getColor());
        // g.fillOval((gridSize - chessSize) / 2, (gridSize - chessSize) / 2, chessSize,
        // chessSize);// draw a point
        // }

        // todo:complete the grapg methords or use other ways to draw the line
    }

    @Override
    public void paintComponent(Graphics g) {
        super.printComponents(g);
        drawPiece(g);
    }

}
