
package Components;

import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.plaf.DimensionUIResource;

import java.awt.*;

import Model.ChessPiece;
import Core.*;

public class ChessBoardPanel extends JPanel {
    private int boardRows = 8;// 行数
    private int boardCols = 8;// 列数
    private static int everyFromLength = 50;
    private ChessPanel[][] chessBoard;// 棋盘
    private int[][] lastChessGrids;
    private int[][] saveGrids;

    public ChessBoardPanel(int boardRows, int boardCols) {
        this.setVisible(true);
        this.setFocusable(true);
        this.setLayout(new GridLayout(this.boardRows, this.boardCols));
        this.setBackground(Color.PINK);// todo: choose a beautiful color
        this.boardRows = boardRows;
        this.boardCols = boardCols;
        chessBoard = new ChessPanel[boardRows][boardCols];
        ChessPanel.setSize(100);
        intitalChessPanel();
    }

    public void intitalChessPanel() {// 初始化每个格子
        this.lastChessGrids = new int[8][8];
        this.saveGrids = new int[8][8];
        for (int i = 0; i != boardRows; ++i) {
            for (int j = 0; j != boardCols; ++j) {
                ChessPanel tempPanel = new ChessPanel(i, j);
                this.add(tempPanel);
                chessBoard[i][j] = tempPanel;
            }
        }
    }

    public void setChess(int row, int col, ChessPiece chess) {// 在指定格子放棋
        chessBoard[row][col].setChessPiece(chess);
    }

    public ChessPiece getChess(int y, int x) {
        return chessBoard[y][x].getChessPiece();
    }

    public boolean canClickGrid(int row, int col, ChessPiece currentPlayer) {// 判断该格子是否可以放棋
        int[][] digitBoard = new int[8][8];
        int color;
        if (currentPlayer == ChessPiece.BLACK) {
            color = -1;
        } else {
            color = 1;
        }
        for (int i = 0; i < 8; i++) {
            for (int j = 0; j < 8; j++) {
                if (chessBoard[i][j].getChessPiece() == ChessPiece.BLACK) {
                    digitBoard[i][j] = -1;
                }
                if (chessBoard[i][j].getChessPiece() == ChessPiece.WHITE) {
                    digitBoard[i][j] = 1;
                }
                if (chessBoard[i][j].getChessPiece() == ChessPiece.EMPTY) {
                    digitBoard[i][j] = 0;
                }
            }
        }

        for (int i = 0; i < 8; i++) { // 刷新棋盘之前把上一步拷到undogrids里
            for (int j = 0; j < 8; j++) {
                if (chessBoard[i][j].getChessPiece() == ChessPiece.BLACK) {
                    lastChessGrids[i][j] = -1;
                }
                if (chessBoard[i][j].getChessPiece() == ChessPiece.WHITE) {
                    lastChessGrids[i][j] = 1;
                }
                if (chessBoard[i][j].getChessPiece() == ChessPiece.EMPTY) {
                    lastChessGrids[i][j] = 0;
                }
            }
        }

        DigitBoard d = new DigitBoard(row, col, color, digitBoard);
        d.DoLogic();
        for (int i = 0; i < 8; i++) {
            for (int j = 0; j < 8; j++) {
                if (d.getAns(i, j) == -1) {
                    chessBoard[i][j].setChessPiece(ChessPiece.BLACK);
                }
                if (d.getAns(i, j) == 1) {
                    chessBoard[i][j].setChessPiece(ChessPiece.WHITE);
                }
                if (d.getAns(i, j) == 0) {
                    chessBoard[i][j].setChessPiece(ChessPiece.EMPTY);
                }
            }
        }
        repaint();
        return d.getAns(row, col) == color;
    }

    public void undoStep() { // 读取撤销棋盘
        for (int i = 0; i < 8; i++) {
            for (int j = 0; j < 8; j++) {
                if (lastChessGrids[i][j] == -1) {
                    chessBoard[i][j].setChessPiece(ChessPiece.BLACK);
                }
                if (lastChessGrids[i][j] == 1) {
                    chessBoard[i][j].setChessPiece(ChessPiece.WHITE);
                }
                if (lastChessGrids[i][j] == 0) {
                    chessBoard[i][j].setChessPiece(ChessPiece.EMPTY);
                }
            }
        }
        repaint();
    }

    public void saveGame() { // 存档 存一个txt 由210和最后一步玩家(玩家在gamecore写入)组成 简陋但有效
        for (int i = 0; i < 8; i++) {
            for (int j = 0; j < 8; j++) {
                if (chessBoard[i][j].getChessPiece() == ChessPiece.BLACK) {
                    saveGrids[i][j] = 2;
                }
                if (chessBoard[i][j].getChessPiece() == ChessPiece.WHITE) {
                    saveGrids[i][j] = 1;
                }
                if (chessBoard[i][j].getChessPiece() == ChessPiece.EMPTY) {
                    saveGrids[i][j] = 0;
                }
            }
        }
    }

    public void readGame(String readGame) { // 读取 数字代表棋子颜色
        for (int i = 0; i < 8; i++) {
            for (int j = 0; j < 8; j++) {
                String substring = readGame.substring(i * 8 + j, i * 8 + j + 1);
                if (substring.equals("2")) {
                    chessBoard[i][j].setChessPiece(ChessPiece.BLACK);
                }
                if (substring.equals("1")) {
                    chessBoard[i][j].setChessPiece(ChessPiece.WHITE);
                }
                if (substring.equals("0")) {
                    chessBoard[i][j].setChessPiece(ChessPiece.EMPTY);
                }
            }
        }
        repaint();
    }

    @Override
    public String toString() { // 存档用
        StringBuilder saveString = new StringBuilder();
        for (int i = 0; i < 8; i++) {
            for (int j = 0; j < 8; j++) {
                saveString.append(saveGrids[i][j]);
            }
        }
        return String.valueOf(saveString);
    }

    @Override
    public Dimension getPreferredSize() {
        return chessBoard[0][0].getPreferredSize();
    }

    public void autoZoom(int width, int height) {// zoom
        this.setSize(chessBoard[0][0].getPreferredSize());
        // System.out.println("board\t" + this.getWidth() + "\t" + this.getHeight());
    }
}