if(PKG_USER-PLUMED)
  set(PLUMED_MODE "static" CACHE STRING "Linkage mode for Plumed2 library")
  set(PLUMED_MODE_VALUES static shared runtime)
  set_property(CACHE PLUMED_MODE PROPERTY STRINGS ${PLUMED_MODE_VALUES})
  validate_option(PLUMED_MODE PLUMED_MODE_VALUES)
  string(TOUPPER ${PLUMED_MODE} PLUMED_MODE)

  set(PLUMED_LINK_LIBS "")
  if(PLUMED_MODE STREQUAL "STATIC")
    find_package(LAPACK REQUIRED)
    find_package(BLAS REQUIRED)
    find_package(GSL REQUIRED)
    list(APPEND LAPACK_LIBRARIES ${BLAS_LIBRARIES})
    list(APPEND PLUMED_LINK_LIBS ${LAPACK_LIBRARIES} ${GSL_LIBRARIES})
    find_package(ZLIB QUIET)
    if(ZLIB_FOUND)
      list(APPEND PLUMED_LINK_LIBS ${ZLIB_LIBRARIES})
    endif()
  endif()

  find_package(PkgConfig QUIET)
  set(DOWNLOAD_PLUMED_DEFAULT ON)
  if(PKG_CONFIG_FOUND)
    pkg_check_modules(PLUMED QUIET plumed)
    if(PLUMED_FOUND)
      set(DOWNLOAD_PLUMED_DEFAULT OFF)
    endif()
  endif()

  option(DOWNLOAD_PLUMED "Download Plumed package instead of using an already installed one" ${DOWNLOAD_PLUMED_DEFAULT})
  if(DOWNLOAD_PLUMED)
    if(CMAKE_GENERATOR STREQUAL "Ninja")
      message(FATAL_ERROR "Cannot build downloaded Plumed library with Ninja build tool")
    endif()
    if(BUILD_MPI)
      set(PLUMED_CONFIG_MPI "--enable-mpi")
      set(PLUMED_CONFIG_CC  ${CMAKE_MPI_C_COMPILER})
      set(PLUMED_CONFIG_CXX  ${CMAKE_MPI_CXX_COMPILER})
    else()
      set(PLUMED_CONFIG_MPI "--disable-mpi")
      set(PLUMED_CONFIG_CC  ${CMAKE_C_COMPILER})
      set(PLUMED_CONFIG_CXX  ${CMAKE_CXX_COMPILER})
    endif()
    if(BUILD_OMP)
      set(PLUMED_CONFIG_OMP "--enable-openmp")
    else()
      set(PLUMED_CONFIG_OMP "--disable-openmp")
    endif()
    message(STATUS "PLUMED download requested - we will build our own")
    include(ExternalProject)
    ExternalProject_Add(plumed_build
      URL https://github.com/plumed/plumed2/releases/download/v2.5.2/plumed-src-2.5.2.tgz
      URL_MD5 bd2f18346c788eb54e1e52f4f6acf41a
      BUILD_IN_SOURCE 1
      CONFIGURE_COMMAND <SOURCE_DIR>/configure --prefix=<INSTALL_DIR>
                                               ${CONFIGURE_REQUEST_PIC}
                                               --enable-modules=all
                                               ${PLUMED_CONFIG_MPI}
                                               ${PLUMED_CONFIG_OMP}
                                               CXX=${PLUMED_CONFIG_CXX}
                                               CC=${PLUMED_CONFIG_CC}
    )
    ExternalProject_get_property(plumed_build INSTALL_DIR)
    set(PLUMED_INSTALL_DIR ${INSTALL_DIR})
    list(APPEND LAMMPS_DEPS plumed_build)
    if(PLUMED_MODE STREQUAL "STATIC")
      add_definitions(-D__PLUMED_WRAPPER_CXX=1)
      list(APPEND LAMMPS_LINK_LIBS ${PLUMED_INSTALL_DIR}/lib/libplumed.a ${PLUMED_LINK_LIBS} ${CMAKE_DL_LIBS})
    elseif(PLUMED_MODE STREQUAL "SHARED")
      list(APPEND LAMMPS_LINK_LIBS ${PLUMED_INSTALL_DIR}/lib/libplumed${CMAKE_SHARED_LIBRARY_SUFFIX} ${PLUMED_INSTALL_DIR}/lib/libplumedKernel${CMAKE_SHARED_LIBRARY_SUFFIX} ${CMAKE_DL_LIBS})
    elseif(PLUMED_MODE STREQUAL "RUNTIME")
      add_definitions(-D__PLUMED_HAS_DLOPEN=1 -D__PLUMED_DEFAULT_KERNEL=${PLUMED_INSTALL_DIR}/lib/libplumedKernel${CMAKE_SHARED_LIBRARY_SUFFIX})
      list(APPEND LAMMPS_LINK_LIBS ${PLUMED_INSTALL_DIR}/lib/libplumedWrapper.a -rdynamic ${CMAKE_DL_LIBS})
    endif()
    set(PLUMED_INCLUDE_DIRS "${PLUMED_INSTALL_DIR}/include")
  else()
    find_package(PkgConfig REQUIRED)
    pkg_check_modules(PLUMED REQUIRED plumed)
    if(PLUMED_MODE STREQUAL "STATIC")
      add_definitions(-D__PLUMED_WRAPPER_CXX=1)
      include(${PLUMED_LIBDIR}/plumed/src/lib/Plumed.cmake.static)
    elseif(PLUMED_MODE STREQUAL "SHARED")
      include(${PLUMED_LIBDIR}/plumed/src/lib/Plumed.cmake.shared)
    elseif(PLUMED_MODE STREQUAL "RUNTIME")
      add_definitions(-D__PLUMED_HAS_DLOPEN=1 -D__PLUMED_DEFAULT_KERNEL=${PLUMED_LIBDIR}/libplumedKernel${CMAKE_SHARED_LIBRARY_SUFFIX})
      include(${PLUMED_LIBDIR}/plumed/src/lib/Plumed.cmake.runtime)
    endif()
    list(APPEND LAMMPS_LINK_LIBS ${PLUMED_LOAD})
  endif()
  include_directories(${PLUMED_INCLUDE_DIRS})
endif()
