/* -*- c++ -*- ----------------------------------------------------------
   LAMMPS - Large-scale Atomic/Molecular Massively Parallel Simulator
   http://lammps.sandia.gov, Sandia National Laboratories
   Steve Plimpton, sjplimp@sandia.gov

   Copyright (2003) Sandia Corporation.  Under the terms of Contract
   DE-AC04-94AL85000 with Sandia Corporation, the U.S. Government retains
   certain rights in this software.  This software is distributed under
   the GNU General Public License.

   See the README file in the top-level LAMMPS directory.
------------------------------------------------------------------------- */

/* ----------------------------------------------------------------------
   Contributing authors: Shen,Yuan, Qi,Tingting, and Reed,Evan
   Implementation of the colored thermostat for quantum nuclear effects
------------------------------------------------------------------------- */

#ifdef FIX_CLASS

FixStyle(qtb,FixQTB)

#else

#ifndef LMP_FIX_QTB_H
#define LMP_FIX_QTB_H

#include "fix.h"

namespace LAMMPS_NS {

class FixQTB : public Fix {
 public:
  FixQTB(class LAMMPS *, int, char **);
  virtual ~FixQTB();
  int setmask();
  void init();
  void setup(int);
  void post_force(int);
  void post_force_respa(int, int, int);
  int modify_param(int, char **);
  double memory_usage();
  void grow_arrays(int);
  void copy_arrays(int, int, int);
  int pack_exchange(int, double *);
  int unpack_exchange(int, double *);

 private:
  // qtb parameters
  int counter_mu;						// counter l and mu
  double t_period, fric_coef;					// friction coefficient
  int seed;                        				// seed for the random number generator
  double f_max;                  				// frequency cutoff
  int N_f;                  					// number of frequency grid
  double t_target;						// target qtb temperature
  char *id_temp;
  class Compute *temperature;
  double h_timestep;						// time step to update the random forces
  int alpha;							// number of time steps to update the random forces
  class RanMars *random;					// random number generator
  double *gfactor1,*gfactor3;					// factors of frictions and random forces
  double *omega_H,*time_H;					// H gives the desired power spectrum
  double **random_array_0, **random_array_1, **random_array_2;	// random number arrays give independence between atoms and directions
  int nlevels_respa;
  double **fran, fsum[3], fsumall[3];				// random forces and their sums
};

}

#endif
#endif
