/* -*- c++ -*- ----------------------------------------------------------
   LAMMPS - Large-scale Atomic/Molecular Massively Parallel Simulator
   http://lammps.sandia.gov, Sandia National Laboratories
   Steve Plimpton, sjplimp@sandia.gov

   Copyright (2003) Sandia Corporation.  Under the terms of Contract
   DE-AC04-94AL85000 with Sandia Corporation, the U.S. Government retains
   certain rights in this software.  This software is distributed under
   the GNU General Public License.

   See the README file in the top-level LAMMPS directory.
------------------------------------------------------------------------- */

#ifdef REGION_CLASS

RegionStyle(block/kk,RegBlockKokkos<LMPDeviceType>)
RegionStyle(block/kk/device,RegBlockKokkos<LMPDeviceType>)
RegionStyle(block/kk/host,RegBlockKokkos<LMPHostType>)

#else

#ifndef LMP_REGION_BLOCK_KOKKOS_H
#define LMP_REGION_BLOCK_KOKKOS_H

#include "region_block.h"
#include "kokkos_type.h"

namespace LAMMPS_NS {

struct TagRegBlockMatchAll{};

template<class DeviceType>
class RegBlockKokkos : public RegBlock {
  friend class FixPour;

 public:
  typedef DeviceType device_type;
  typedef ArrayTypes<DeviceType> AT;

  RegBlockKokkos(class LAMMPS *, int, char **);
  ~RegBlockKokkos();
  void match_all_kokkos(int, DAT::tdual_int_1d);

  KOKKOS_INLINE_FUNCTION
  void operator()(TagRegBlockMatchAll, const int&) const;

 private:
  int groupbit;
  typename AT::t_int_1d d_match;

  typename AT::t_x_array_randomread x;
  typename AT::t_int_1d_randomread mask;

  KOKKOS_INLINE_FUNCTION
  int k_inside(double, double, double) const;
  KOKKOS_INLINE_FUNCTION
  int match(double, double, double) const;
  KOKKOS_INLINE_FUNCTION
  void inverse_transform(double &, double &, double &) const;
  KOKKOS_INLINE_FUNCTION
  void rotate(double &, double &, double &, double) const;

};

}

#endif
#endif

/* ERROR/WARNING messages:

E: Cannot use region INF or EDGE when box does not exist

Regions that extend to the box boundaries can only be used after the
create_box command has been used.

E: Illegal ... command

Self-explanatory.  Check the input script syntax and compare to the
documentation for the command.  You can use -echo screen as a
command-line option when running LAMMPS to see the offending line.

*/
