#!/usr/bin/env python3
# coding=utf-8
#
# Import exploit database into cve-search
#
# Origin: https://github.com/offensive-security/exploit-database
#
# Software is free software released under the "Modified BSD license"
#
# Copyright (c) 2015    Alexandre Dulaunoy - a@foo.be

import os
import sys
import shutil
runPath = os.path.dirname(os.path.realpath(__file__))
sys.path.append(os.path.join(runPath, ".."))

from lib.Config import Configuration
import lib.DatabaseLayer as db

import csv
import argparse

# dictionary
exploitdburl = Configuration.getexploitdbDict()
tmppath = Configuration.getTmpdir()

argparser = argparse.ArgumentParser(description='Populate/update the exploitdb ref database')
argparser.add_argument('-v', action='store_true', help='verbose output', default=False)
args = argparser.parse_args()


try:
    f = Configuration.getFile(exploitdburl)
except:
    sys.exit("Cannot open url %s. Bad URL or not connected to the internet?"%(exploitdburl))

i = db.getLastModified('exploitdb')
if i is not None:
    if f.headers['last-modified'] == i:
        print("Not modified")
        sys.exit(0)

if not os.path.exists(tmppath):
    os.mkdir(tmppath)

csvfile = tmppath+'/exploitdb.csv'
with open(csvfile, 'wb') as fp:
    shutil.copyfileobj(f, fp)
fp.close()

exploits=[]
with open(csvfile, newline='') as csvtoparse:
    exploitcsv = csv.DictReader(csvtoparse, delimiter=',')
    for row in exploitcsv:
        exploits.append(row)
        if args.v:
            print ("{} ({}) Imported".format(row['id'],row['description']))
db.bulkUpdate('exploitdb', exploits)

# Update last-modified
db.setColUpdate('exploitdb', f.headers['last-modified'])
