import __main__

def get_routes(app):
    from web.advanced_api import Advanced_API
    from web.minimal      import Minimal
    from web.index        import Index

    def instanceof(data, type_):
        if hasattr(__main__, type_.__name__):
            return isinstance(data, (type_, getattr(__main__, type_.__name__)))
        return isinstance(data, type_)


    ROUTES = [
        {'r': '/api/',                               'm': ['GET'], 'f': app.api_documentation},
        {'r': '/api/cpe2.3/<path:cpe>',              'm': ['GET'], 'f': app.api_cpe23},
        {'r': '/api/cpe2.2/<path:cpe>',              'm': ['GET'], 'f': app.api_cpe22},
        {'r': '/api/cvefor/<path:cpe>',              'm': ['GET'], 'f': app.api_cvesFor},
        {'r': '/api/cve/<cveid>',                    'm': ['GET'], 'f': app.api_cve},
        {'r': '/api/cwe',                            'm': ['GET'], 'f': app.api_cwe},
        {'r': '/api/cwe/<int:cwe_id>',               'm': ['GET'], 'f': app.api_cwe},
        {'r': '/api/capec/<cweid>',                  'm': ['GET'], 'f': app.api_capec},
        {'r': '/api/last',                           'm': ['GET'], 'f': app.api_last},
        {'r': '/api/last/',                          'm': ['GET'], 'f': app.api_last},
        {'r': '/api/last/<int:limit>',               'm': ['GET'], 'f': app.api_last},
        {'r': '/api/query',                          'm': ['GET'], 'f': app.api_query},
        {'r': '/api/browse',                         'm': ['GET'], 'f': app.api_browse},
        {'r': '/api/browse/',                        'm': ['GET'], 'f': app.api_browse},
        {'r': '/api/browse/<path:vendor>',           'm': ['GET'], 'f': app.api_browse},
        {'r': '/api/search/<vendor>/<path:product>', 'm': ['GET'], 'f': app.api_search},
        {'r': '/api/search/<path:search>',           'm': ['GET'], 'f': app.api_text_search},
        {'r': '/api/link/<key>/<value>',             'm': ['GET'], 'f': app.api_link},
        {'r': '/api/dbInfo',                         'm': ['GET'], 'f': app.api_dbInfo} ]
    if instanceof(app, Advanced_API):
        ROUTES.extend( [
            {'r': '/api/admin/whitelist',            'm': ['GET'],  'f': app.api_admin_whitelist},
            {'r': '/api/admin/blacklist',            'm': ['GET'],  'f': app.api_admin_blacklist},
            {'r': '/api/admin/whitelist/export',     'm': ['GET'],  'f': app.api_admin_whitelist},
            {'r': '/api/admin/blacklist/export',     'm': ['GET'],  'f': app.api_admin_blacklist},
            {'r': '/api/admin/whitelist/import',     'm': ['PUT'],  'f': app.api_admin_import_whitelist},
            {'r': '/api/admin/blacklist/import',     'm': ['PUT'],  'f': app.api_admin_import_blacklist},
            {'r': '/api/admin/whitelist/drop',       'm': ['POST'], 'f': app.api_admin_drop_whitelist},
            {'r': '/api/admin/blacklist/drop',       'm': ['POST'], 'f': app.api_admin_drop_blacklist},
            {'r': '/api/admin/whitelist/add',        'm': ['PUT'],  'f': app.api_admin_add_whitelist},
            {'r': '/api/admin/blacklist/add',        'm': ['PUT'],  'f': app.api_admin_add_blacklist},
            {'r': '/api/admin/whitelist/remove',     'm': ['PUT'],  'f': app.api_admin_remove_whitelist},
            {'r': '/api/admin/blacklist/remove',     'm': ['PUT'],  'f': app.api_admin_remove_blacklist},
            {'r': '/api/admin/get_token',            'm': ['GET'],  'f': app.api_admin_get_token},
            {'r': '/api/admin/new_token',            'm': ['GET'],  'f': app.api_admin_generate_token},
            {'r': '/api/admin/get_session',          'm': ['GET'],  'f': app.api_admin_get_session},
            {'r': '/api/admin/start_session',        'm': ['GET'],  'f': app.api_admin_start_session},
            {'r': '/api/admin/updatedb',             'm': ['GET'],  'f': app.api_update_db} ] )
    if instanceof(app, Minimal):
        ROUTES.extend( [
            {'r': '/',                               'm': ['GET'],  'f': app.index},
            {'r': '/',                               'm': ['POST'], 'f': app.index_post},
            {'r': '/r/<int:r>',                      'm': ['GET'],  'f': app.index_filter_get},
            {'r': '/r/<int:r>',                      'm': ['POST'], 'f': app.index_filter_post},
            {'r': '/cve/<cveid>',                    'm': ['GET'],  'f': app.cve},
            {'r': '/cwe',                            'm': ['GET'],  'f': app.cwe},
            {'r': '/cwe/<cweid>',                    'm': ['GET'],  'f': app.relatedCWE},
            {'r': '/capec/<capecid>',                'm': ['GET'],  'f': app.capec},
            {'r': '/browse',                         'm': ['GET'],  'f': app.browse},
            {'r': '/browse/',                        'm': ['GET'],  'f': app.browse},
            {'r': '/browse/<vendor>',                'm': ['GET'],  'f': app.browse},
            {'r': '/search/<vendor>/<path:product>', 'm': ['GET'],  'f': app.search},
            {'r': '/search',                         'm': ['POST'], 'f': app.freetext_search},
            {'r': '/link/<key>/<value>',             'm': ['GET'],  'f': app.link} ] )
    if instanceof(app, Index):
        ROUTES.extend( [
            {'r': '/cve/<cveid>',                             'm': ['GET'],  'f': app.cve},
            {'r': '/_get_plugins',                            'm': ['GET'],  'f': app._get_plugins},
            {'r': '/plugin/_get_cve_actions',                 'm': ['GET'],  'f': app._get_cve_actions},
            {'r': '/plugin/<plugin>',                         'm': ['GET'],  'f': app.openPlugin},
            {'r': '/plugin/<plugin>/subpage/<page>',          'm': ['GET'],  'f': app.openPluginSubpage},
            {'r': '/plugin/<plugin>/_cve_action/<action>',    'm': ['GET'],  'f': app._jsonCVEAction},
            {'r': '/login',                                   'm': ['POST'], 'f': app.login_check},
            {'r': '/logout',                                  'm': ['GET'],  'f': app.logout},
            {'r': '/admin',                                   'm': ['GET'],  'f': app.admin},
            {'r': '/admin/',                                  'm': ['GET'],  'f': app.admin},
            {'r': '/admin/change_pass',                       'm': ['GET'],  'f': app.change_pass},
            {'r': '/admin/request_token',                     'm': ['GET'],  'f': app.request_token},
            {'r': '/admin/updatedb',                          'm': ['GET'],  'f': app.updatedb},
            {'r': '/admin/whitelist/import',                  'm': ['POST'], 'f': app.listImport},
            {'r': '/admin/blacklist/import',                  'm': ['POST'], 'f': app.listImport},
            {'r': '/admin/whitelist/export',                  'm': ['GET'],  'f': app.listExport},
            {'r': '/admin/blacklist/export',                  'm': ['GET'],  'f': app.listExport},
            {'r': '/admin/whitelist/drop',                    'm': ['POST'], 'f': app.listDrop},
            {'r': '/admin/blacklist/drop',                    'm': ['POST'], 'f': app.listDrop},
            {'r': '/admin/whitelist',                         'm': ['GET'],  'f': app.listView},
            {'r': '/admin/blacklist',                         'm': ['GET'],  'f': app.listView},
            {'r': '/admin/addToList',                         'm': ['GET'],  'f': app.listAdd},
            {'r': '/admin/removeFromList',                    'm': ['GET'],  'f': app.listRemove},
            {'r': '/admin/editInList',                        'm': ['GET'],  'f': app.listEdit},
            {'r': '/admin/listmanagement',                    'm': ['GET'],  'f': app.listManagement},
            {'r': '/admin/listmanagement/<vendor>',           'm': ['GET'],  'f': app.listManagement},
            {'r': '/admin/listmanagement/<vendor>/<product>', 'm': ['GET'],  'f': app.listManagement},
            {'r': '/admin/listmanagement/add',                'm': ['GET'],  'f': app.listManagementAdd}])

    return ROUTES
