#!/usr/bin/env python3
# -*- coding: utf-8 -*-
#
# Importing CPE entries in a Redis database to improve lookup
#
# Until now, this part is only used by the web interface to improve response time
#
# Software is free software released under the "Modified BSD license"
#
# Copyright (c) 2014-2015  Alexandre Dulaunoy - a@foo.be
# Copyright (c) 2014-2017  Pieter-Jan Moreels - pieterjan.moreels@gmail.com

# Imports
import argparse
import os
import sys
runPath = os.path.dirname(os.path.realpath(__file__))
sys.path.append(os.path.join(runPath, ".."))

from redis import exceptions as redisExceptions

from lib.Config        import Configuration
from lib.DatabaseLayer import DatabaseLayer
from lib.Toolkit       import pad

argParser = argparse.ArgumentParser(description='CPE entries importer in Redis cache')
argParser.add_argument('-v', action='store_true', default=False, help='Verbose logging')
argParser.add_argument('-o', action='store_true', default=False, help='Import cpeother database in Redis cache')
args = argParser.parse_args()

if args.o:
    cpe = DatabaseLayer().CPE.getAllAlternative()
else:
    cpe = DatabaseLayer().CPE.getAll()

try:
    r = Configuration.getRedisVendorConnection()
except:
    sys.exit(1)

for e in cpe:
    try:
        if not args.o:
            if e.id.count(':') > 4:
                value = ":".join(e.id.split(':')[:6])
            (prefix, cpeversion, cpetype, vendor, product, version) = pad(value.split(':'),6)
        else:
            (prefix, cpeversion, cpetype, vendor, product, version, *remaining) = pad(e.id.split(':'),6)
    except Exception as ex:
        print(ex)
        pass
    try:
        if args.v:
            print(value + " added")
        r.sadd("prefix:" + prefix, cpetype)
        r.sadd("t:/" + cpetype, vendor)
        r.sadd("v:" + vendor, product)
        if version:
            r.sadd("p:" + product, version)
    except redisExceptions.ConnectionError:
        sys.exit("Redis server not running on %s:%s"%(Configuration.getRedisHost(),Configuration.getRedisPort()))
