#!/usr/bin/env python3
# -*- coding: utf-8 -*-
#
# Software is free software released under the "Modified BSD license"
#
# Copyright (c) 2014       psychedelys
# Copyright (c) 2015-2017  Pieter-Jan Moreels - pieterjan.moreels@gmail.com
# Copyright (c) 2015       Alexandre Dulaunoy - a@foo.be

# Imports
import argparse
import json
import os
import sys
import urllib.parse

runPath = os.path.dirname(os.path.realpath(__file__))
sys.path.append(os.path.join(runPath, ".."))

from lib.DatabaseLayer import DatabaseLayer

def output(cpe, output_format="json"):
    if output_format == "json":
        output = [{'id': i.id, 'title': i.title} for i in data]
        print(json.dumps(output, sort_keys=True, indent=4))
    elif output_format == "compact":
        print("\n".join([i.id for i in data]))
    elif output_format == "expanded":
        print("\n".join(["%s  %s"%(i.id, i.title) for i in data]))

if __name__ == "__main__":
    argParser = argparse.ArgumentParser(description='Search for CPE with a pattern')
    argParser.add_argument('-s', type=str, required=True, help='search in cpe list')
    argParser.add_argument('-o', type=str, default='expanded' ,help='O = output format [expanded, compact, json] (default: expanded)')
    argParser.add_argument('-f', action='store_true', help='Enlarge the CPE search to all CPE indexed. Need the cpeother activated.', default=False)

    args = argParser.parse_args()
    data = DatabaseLayer().CPE.get_regex(urllib.parse.quote(args.s), args.f)

    output(data, args.o)
