#!/usr/bin/env python3
# -*- coding: utf-8 -*-
#
# Tool to dump in JSON the database along with the associated ranking
#
# Software is free software released under the "Modified BSD license"
#
# Copyright (c) 2012-2015 	Alexandre Dulaunoy - a@foo.be
# Copyright (c) 2015-2017   Pieter-Jan Moreels - pieterjan.moreels@gmail.com
import argparse
import json
import os
import sys
runPath = os.path.dirname(os.path.realpath(__file__))
sys.path.append(os.path.join(runPath, ".."))

from lib.DatabaseLayer import DatabaseLayer

def dump(limit, ranking=False, via4=False, capec=False):
    db = DatabaseLayer()
    for cve in db.CVE.last(limit=limit, via4=via4, ranking=ranking):
        item = cve.dict(capec, human_dates=True)
        print(json.dumps(item, sort_keys=True))

if __name__ == "__main__":
    argParser = argparse.ArgumentParser(description='Dump database in JSON format')
    argParser.add_argument('-r', default=False, action='store_true', help='Include ranking value')
    argParser.add_argument('-v', default=False, action='store_true', help='Include via4 map')
    argParser.add_argument('-c', default=False, action='store_true', help='Include CAPEC information')
    argParser.add_argument('-l', default=False, type=int, help='Limit output to n elements (default: unlimited)')
    args = argParser.parse_args()

    dump(args.l, args.r, args.v, args.c)
