#!/usr/bin/env python3
#
# cve_doc converts CVE to asciidoc
#
# Software is free software released under the "Modified BSD license"
#
# Copyright (c) 2015       Alexandre Dulaunoy - a@foo.be

# Imports
import json
import os
import re
import sys
runPath = os.path.dirname(os.path.realpath(__file__))
sys.path.append(os.path.join(runPath, ".."))

from optparse import OptionParser

from lib.Query  import Query
from lib.Output import output

optp = OptionParser()
optp.add_option('-c', '--cve', dest='cve', default='CVE-2015-0001', help='CVE id to convert')
optp.add_option('-a', '--api', dest='api', help='HTTP API url (default: http://cve.circl.lu)')
(opts, args) = optp.parse_args()

cve = Query(api=opts.api).cve(opts.cve)
if not cve:
    sys.exit(10)

print(output(cve, "asciidoc"))
